// sonar.ino: operate a HC04 ultrasonic range sensor
// No copyright, 2020, Garth Zeglin.  This file is explicitly placed in the public domain.

// Run a measurement cycle on the sonar range sensor. Returns the round-trip
// time in microseconds.  Returns zero if no ping is detected.  This code
// assumes the pin constants are defined in another file.
int ping_sonar(void)
{
  // Generate a short trigger pulse.
  digitalWrite(sonarTriggerPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(sonarTriggerPin, LOW);

  // Measure the echo pulse length.  The ~6 ms timeout is chosen for a maximum
  // range of 100 cm assuming sound travels at 340 meters/sec.  With a round
  // trip of 2 meters distance, the maximum ping time is 2/340 = 0.0059
  // seconds.  You may wish to customize this for your particular hardware.
  const unsigned long TIMEOUT = 5900;
  unsigned long ping_time = pulseIn(sonarEchoPin, HIGH, TIMEOUT);
	
  return ping_time;
}
//================================================================
