# performance.py

# Abstract performance interface for operating the suitcase and lighting hardware on either
# the Webots simulation or the physical hardware.

# No copyright, 2023, Garth Zeglin.  This file is explicitly placed in the public domain.

print("loading performance.py...")

# Standard Python imports.
import math, random

################################################################
# Define the superclass for controller objects which can drive either a Webots
# simulation or a physical machine.

class Performance:
    def __init__(self):
        self.lights = {'left' : 1.0, 'right' : 1.0 }
        self.num_motors = 4
        self.target = [0, 0, 0, 0]

    def set_spotlight(self, name, intensity):
        self.lights[name] = intensity

    def set_motor_target(self, motornum, pos):
        self.target[motornum] = pos

    # Entry point for periodic updates.
    def poll(self, t):
        pass
