# script.py
# Sample abstract performance script for operating the suitcase and lighting hardware on either
# the Webots simulation or the physical hardware.
# No copyright, 2023, Garth Zeglin.  This file is explicitly placed in the public domain.

print("loading script.py...")

# Standard Python imports.
import math, random

# Define the abstract performance interface.
from performance import Performance

# Define an abstract performance controller which can run either the Webots simulation or a physical machine.
class SuitcasePerformance(Performance):
    def __init__(self):

        # Initialize the superclass which implements the abstract robot interface.
        super().__init__()

        # Initialize the controller state machine
        self.last_t = 0.0
        self.event_timer = 0.0
        self.state_index = 'rest'

    # Entry point for periodic updates.
    def poll(self, t):
        dt = t - self.last_t
        self.last_t = t

        # Change the target velocity in a cycle with a two-second period.
        self.event_timer -= dt
        if self.event_timer < 0:
            if self.state_index == 'rest':
                self.set_spotlight('right', 1.0)
                self.set_spotlight('left', 0.0)
                self.state_index = 'moving'
                self.event_timer += 1.5
                for j in range(self.num_motors):
                    pos = math.pi * (1 - 2*random.random())
                    self.set_motor_target(j, pos)

            else:
                self.state_index = 'rest'
                self.set_spotlight('right', 0.0)
                self.set_spotlight('left', 1.0)
                self.event_timer += 0.5
                for j in range(self.num_motors):
                    self.set_motor_target(j, 0)

            print(f"Switched to state {self.state_index}")
