#!/usr/bin/env python
# demo file processor to remove background

import argparse
import cv2 as cv
import rcpcv.demo

bgs = cv.createBackgroundSubtractorMOG2()

#================================================================
def remove_frame_background(frame, args):
    # update the background subtractor and obtain a new foreground mask
    mask = bgs.apply(frame)

    # convert the mask back to RGB and apply it the source image
    binary = cv.cvtColor(mask, cv.COLOR_GRAY2BGR)
    return frame * binary

#================================================================
if __name__ == "__main__":
    parser = argparse.ArgumentParser( description = "Demo to remove background.")
    args = rcpcv.demo.parse_args(parser)
    rcpcv.demo.run_filter(args, remove_frame_background)
