#!/usr/bin/env python
# demo of blending images into an accumulator to smooth across time

import argparse
import cv2 as cv
import rcpcv.demo

# global frame accumulator
average = None

def blend_frame(frame, args):
    global average

    if average is None:
        average = frame * 0

    else:
        average = cv.addWeighted(average, 0.9, frame, 0.1, 0.0)
    return average

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description = "Demo to blend multiple frames.")
    args = rcpcv.demo.parse_args(parser)
    rcpcv.demo.run_filter(args, blend_frame)
