#!/usr/bin/env python

import argparse
import cv2 as cv
import rcpcv.demo

def blocky_frame(frame, args):
    rows, cols, channels = frame.shape
    small = cv.resize(frame, dsize=(cols//32,rows//32))
    return cv.resize(small, dsize=(cols, rows), interpolation=cv.INTER_NEAREST)

if __name__ == "__main__":
    parser = argparse.ArgumentParser( description = "Demo to reduce frame size.")
    args = rcpcv.demo.parse_args(parser)
    rcpcv.demo.run_filter(args, blocky_frame)
