#!/usr/bin/env python
# demo of blurring image without reduction

import argparse
import cv2 as cv
import rcpcv.demo

def blur_frame(frame, args):
    if args.gaussian:
        return cv.GaussianBlur(frame, ksize=(15, 15), sigmaX=0)

    elif args.median:
        return cv.medianBlur(frame, ksize=15)

    else:
        # default is a normalized box blur
        return cv.blur(frame, ksize=(15,15))

if __name__ == "__main__":
    parser = argparse.ArgumentParser( description = "Demo to blur images.")
    parser.add_argument('--gaussian',action='store_true', help="Apply Gaussian blurring (default: %(default)s)")
    parser.add_argument('--median',action='store_true', help="Apply median blurring (default: %(default)s)")
    args = rcpcv.demo.parse_args(parser)
    rcpcv.demo.run_filter(args, blur_frame)
