#!/usr/bin/env python

import argparse
import cv2 as cv
import rcpcv.demo

def contour_frame(frame, args):
    bw = cv.cvtColor(frame, cv.COLOR_BGR2GRAY)
    ret, thresholded = cv.threshold(bw, 127, 255, cv.THRESH_BINARY)
    dilated = cv.dilate(thresholded, None, iterations=0)
    contours, hierarchy = cv.findContours(dilated, cv.RETR_EXTERNAL, cv.CHAIN_APPROX_SIMPLE)
    for idx,contour in enumerate(contours):
        cv.drawContours(frame, contours, idx, (128,255,255))
    return frame

if __name__ == "__main__":
    parser = argparse.ArgumentParser( description = "Demo to reduce frame size.")
    args = rcpcv.demo.parse_args(parser)
    rcpcv.demo.run_filter(args, contour_frame)
