#!/usr/bin/env python
# demo of cropping a fixed region

import argparse
import rcpcv.demo

def crop_frame(frame, args):
    rows, cols, channels = frame.shape
    first_row   = rows//2 - args.height//2
    first_col   = cols//2 - args.width//2
    return frame[first_row:first_row+args.height, first_col:first_col+args.width]

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description = "Demo to blend multiple frames.")
    parser.add_argument('--width', default=120, type=int, help="crop width in pixels (default: %(default)s)")
    parser.add_argument('--height', default=120, type=int, help="crop height in pixels (default: %(default)s)")
    args = rcpcv.demo.parse_args(parser)
    rcpcv.demo.run_filter(args, crop_frame)
