#!/usr/bin/env python
# demo  file processor to reduce frame size

import argparse
import rcpcv.demo

#================================================================
# Callback to process a single video frame, returning a new frame.
# The args value is the result of processing the command line arguments.
def reduce_frame(frame, args):
    step = args.step

    # return a matrix view of the frame skipping the specific number of rows and columns
    return frame[::step, ::step]

#================================================================
if __name__ == "__main__":
    parser = argparse.ArgumentParser( description = "Demo to reduce frame size.")
    parser.add_argument('--step', default=2, type=int, help="reduction step size (default: %(default)s)")
    args = rcpcv.demo.parse_args(parser)
    rcpcv.demo.run_filter(args, reduce_frame)
