#!/usr/bin/env python3
"""demo-arm.py : demonstration of scripting arm actions
"""
import argparse, time, logging
import numpy as np

from pythonosc import osc_message_builder
from pythonosc import udp_client

import stage.config
import stage.network

# import common logging functions
import stage.logconfig

# initialize logging for this module
log = logging.getLogger('demo')

#================================================================
if __name__ == "__main__":

    # set up logging
    stage.logconfig.open_log_file('logs/demo-arm.log')
    log.info("Starting demo-arm.py")

    parser = argparse.ArgumentParser( description = "Simple scripted show.")
    parser.add_argument("--ip", default=stage.config.theater_IP,
                        help="IP address of the OSC receiver (default: %(default)s).")
    stage.logconfig.add_logging_args(parser)
    args = parser.parse_args()

    # Modify logging settings as per common arguments.
    stage.logconfig.configure_logging(args)

    # create OSC clients to send messages to the theater system
    network = stage.network.TheaterNetwork(args)

    lights = network.lights
    valve1 = network.valve_server_by_name('valve1')
    valve2 = network.valve_server_by_name('valve2')
    base   = network.motion_server_by_name('arm_base')

    lights.send_message("/fixture", ["rgba1", 255, 0, 0, 255])
    lights.send_message("/fixture", ["rgba2", 0, 255, 255, 0])

    # briefly move each pneumatic axis
    for j in (1, 2):
        valve1.send_message("/move", [j, 100])
        time.sleep(1)
        valve1.send_message("/move", [j, 0])

    for j in (1, 2):
        valve2.send_message("/move", [j, 100])
        time.sleep(1)
        valve2.send_message("/move", [j, 0])

    for j in (1, 2):
        valve1.send_message("/move", [j, -100])
        time.sleep(1)
        valve1.send_message("/move", [j, 0])

    for j in (1, 2):
        valve2.send_message("/move", [j, -100])
        time.sleep(1)
        valve2.send_message("/move", [j, 0])

    # briefly move the base motor
    base.send_message("/spline", [0, 0.0, 180.0, 180.0])
    time.sleep(2)
    base.send_message("/spline", [0, 0.0, -180.0, -180.0])
    time.sleep(2)

    lights.send_message("/fixture", ["rgba1", 0, 0, 0, 0])
    lights.send_message("/fixture", ["rgba2", 0, 0, 0, 0])

    log.info("Exiting demo-arm.py")
