#!/usr/bin/env python3
"""demo-boom-wheel.py : demonstration of scripting boom wheel motor actions
"""
import argparse, time, logging
import numpy as np

from pythonosc import osc_message_builder
from pythonosc import udp_client

import stage.config
import stage.network

# import common logging functions
import stage.logconfig

# initialize logging for this module
log = logging.getLogger('demo')

#================================================================
if __name__ == "__main__":

    # set up logging
    stage.logconfig.open_log_file('logs/demo-boom-wheel.log')
    log.info("Starting demo-boom-wheel.py")

    parser = argparse.ArgumentParser( description = "Simple scripted show.")
    parser.add_argument("--ip", default=stage.config.theater_IP,
                        help="IP address of the OSC receiver (default: %(default)s).")
    stage.logconfig.add_logging_args(parser)
    args = parser.parse_args()

    # Modify logging settings as per common arguments.
    stage.logconfig.configure_logging(args)

    # create OSC clients to send messages to the theater system
    network = stage.network.TheaterNetwork(args)
    wheel   = network.motion_server_by_name('wheel')
    lights  = network.lights

    # briefly move back and forth
    for i in range(4):
        lights.send_message("/fixture", ["rgba3", 255, 255, 255, 255])
        wheel.send_message("/spline", [0, 0.0, 180.0, 180.0])
        time.sleep(2)

        lights.send_message("/fixture", ["rgba3", 0, 0, 255, 0])
        wheel.send_message("/spline", [0, 0.0, -180.0, -180.0])
        time.sleep(2)

    lights.send_message("/fixture", ["rgba3", 0, 0, 0, 0])
    log.info("Exiting demo-boom-wheel.py")
