#!/usr/bin/env python3
"""light-fan-station-demo.py : demonstration of scripting theater actions for a subset of the lights and fans
"""
import argparse, time, logging
import numpy as np

from pythonosc import osc_message_builder
from pythonosc import udp_client

import stage.config
import stage.network

# import common logging functions
import stage.logconfig

# please choose a unique name representing this particular show
show_name = 'window1'

# initialize logging for this module
log = logging.getLogger(show_name)

# define the specific fixtures in the station used by this script
lamp = 'lamp1'
fan  = 'fan1'
rgba = 'rgba1'

#================================================================
if __name__ == "__main__":

    # set up logging
    stage.logconfig.open_log_file('logs/' + show_name + '.log')
    log.info("Starting %s", show_name)

    parser = argparse.ArgumentParser( description = "Simple scripted show.")
    parser.add_argument("--ip", default=stage.config.theater_IP,
                        help="IP address of the OSC receiver (default: %(default)s).")
    stage.logconfig.add_logging_args(parser)
    args = parser.parse_args()

    # Modify logging settings as per common arguments.
    stage.logconfig.configure_logging(args)

    # create OSC clients to send messages to the theater system
    network = stage.network.TheaterNetwork(args)

    # turn on monolight
    network.lights.send_message("/fixture", [lamp, 255])
    log.debug("Lighting fixture %s", lamp)
    time.sleep(1)

    # turn on fan
    network.lights.send_message("/fixture", [fan, 255])
    log.debug("Lighting fixture %s", fan)
    time.sleep(1)

    # RGBA light blue
    network.lights.send_message("/fixture", [rgba] + [0, 0, 255, 0])
    log.debug("Lighting fixture %s", rgba)

    # wait for a duration
    time.sleep(20)

    # turn everything off
    network.lights.send_message("/fixture", [fan, 0])
    log.debug("Lighting fixture %s", fan)

    network.lights.send_message("/fixture", [lamp, 0])
    log.debug("Lighting fixture %s", lamp)

    network.lights.send_message("/fixture", [rgba] + [0, 0, 0, 0])
    log.debug("Lighting fixture %s", rgba)

    log.info("Exiting %s", show_name)
