# Global configuration settings.

# IP address of the dedicated theater server
theater_IP = '172.24.26.199'

# OSC UDP port for director
director_UDP_port = 22000

# OSC UDP port(s) for lighting commands
# lighting_host_IP = '127.0.0.1'
lighting_host_IP = '0.0.0.0'
lighting_UDP_port = 20000
lighting_units = 1

# OSC UDP port(s) for motor commands.  The motor servers occupy sequential UDP port numbers.
# motor_host_IP = '127.0.0.1'
motor_host_IP = '0.0.0.0'
motor_UDP_port = 21000

# OSC UDP port(s) for valve driver commands.  The valve servers occupy sequential UDP port numbers.
# motor_host_IP = '127.0.0.1'
valve_host_IP = '0.0.0.0'
valve_UDP_port = 21100

# OSC UDP port for vision server
vision_UDP_port = 23000

# OSC UDP port for vision clients (this may change)
client_UDP_port = 24000

#================================================================
# Lighting fixture definitions.
fixtures = [
    # all fixtures are numbered left to right as viewed from the hallway
    # DP-415 dimmer:
    {'name': "empty1",   'dmx': 0,  'channels' : 1},
    {'name': "empty2",   'dmx': 1,  'channels' : 1},
    {'name': "lamp1",    'dmx': 2,  'channels' : 1},
    {'name': "lamp2",    'dmx': 3,  'channels' : 1},

    # DP-415 dimmer:
    {'name': "empty3",    'dmx': 4,  'channels' : 1},
    {'name': "empty4",    'dmx': 5,  'channels' : 1},
    {'name': "empty5",    'dmx': 6,  'channels' : 1},
    {'name': "empty6",    'dmx': 7,  'channels' : 1},

    # SlimParPro footlights
    {'name': "rgba1",   'dmx': 8,  'channels' : 4},
    {'name': "rgba2",   'dmx': 12, 'channels' : 4},
    {'name': "rgba3",   'dmx': 16, 'channels' : 4},
    {'name': "rgba4",   'dmx': 20, 'channels' : 4},
    ]

#================================================================
# Motor unit definitions.  On Linux, the device names can change depending on
# the enumeration order.
motor_units = [
    {'name': 'arm_base', 'arduino': '/dev/ttyACM2' },
    {'name': 'wheel',    'arduino': '/dev/ttyACM3' },
    ]

# Valve unit definitions.  On Linux, the device names can change depending on
# the enumeration order.
valve_units = [
    {'name': 'valve1', 'arduino': '/dev/ttyACM0' },
    {'name': 'valve2', 'arduino': '/dev/ttyACM1' },
    ]


#================================================================
# Vision camera regions of interest, specified as pairs of points in (x,y) (col,row) order.

# current visitor window apertures
camera_roi = [[[110, 60], [220, 180]],
              [[450, 50], [550, 170]]]

# for debugging, use lower region to capture background traffic while testing
#camera_roi = [[[110, 190], [220, 260]],
#              [[450, 190], [550, 260]]]

#================================================================
