"""logconfig.py
Common support for configuring the Python logging system."""

import logging

def open_log_file(filename):
    log_format= '%(asctime)s:%(levelname)s:%(name)s: %(message)s'
    log_datefmt="%Y-%m-%d %H:%M:%S"
    log_stream = open(filename, 'a')
    logging.basicConfig(stream=log_stream, level=logging.INFO, format=log_format, datefmt=log_datefmt)


def add_console_log():
    console_handler = logging.StreamHandler()
    console_handler.setLevel(logging.DEBUG)
    console_handler.setFormatter(logging.Formatter('%(levelname)s:%(name)s: %(message)s'))
    logging.getLogger().addHandler(console_handler)

def add_logging_args(parser):
    """Add a standard set of logging options to an argparser."""
    parser.add_argument( '--quiet', action='store_true', help='Disable echoing log output to console.')
    parser.add_argument( '--debug', action='store_true', help='Enable debug messages in logs.' )
    parser.add_argument( '--verbose', action='store_true', help='Enable even more detailed logging output.' )

def configure_logging(args):
    # Enable debug messages in logs on request.
    if args.debug:
        logging.getLogger().setLevel(logging.DEBUG)

    # Enable logging to console by default.
    if not args.quiet:
        add_console_log()
