/// \file Pneumatic.cpp
/// \copyright Copyright (c) 2016, Garth Zeglin.  All rights reserved. Licensed under the terms of the BSD 3-clause license.

#include "Pneumatic.h"

void Pneumatic::update(long interval)
{
  switch (mode) {
  case IDLE:
    break;

  case OPEN_LOOP:

    // Wait for the next event time point.
    timer -= interval;

    if (timer <= 0) {
      
      if (active == 0) {  // no air flow
	set_valves( false, false ); // fill, empty
	timer += period;

      } else if (active > 0) {  	// filling
	if (fill) {
	  set_valves( false, false ); // fill, empty
	  timer += (period - active);

	} else {
	  set_valves( true, false); // fill, empty
	  timer += active;
	}
      } else { // emptying
	if (empty) {
	  set_valves( false, false ); // fill, empty
	  timer += (period - (-active));

	} else {
	  set_valves( false, true);  // fill, empty
	  timer += (-active);
	}
      }
    }
    break;
  }
}
